


//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
Texture2D overlay;            // Color texture for mesh
float    g_fTime;                   // App's time in seconds
int overlay_Width;
int overlay_Height;
int dst_Width;
int dst_Height;
int mode;
int level;

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
SamplerState TextureSampler
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Clamp;//Wrap;
    AddressV = Clamp;//Wrap;
};

struct VS_INPUT
{
    float4 Position   : POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD0;   // vertex texture coords 
};

struct VS_OUTPUT
{
    float4 Position   : SV_POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD1;   // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{	
    float ColorY : SV_Target0;  // Pixel color  
};

struct PS_OUTPUT2
{
	float2 ColorUV : SV_Target0;  // Pixel color   
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
float3 NV12ToRGB_CSC(float4 rgb)
{
    float r = rgb.x;
    float g = rgb.y;
    float b = rgb.z;	    
 
    float y = 0.2126 * r + 0.7152 * g + 0.0722 * b;
    float u = -0.114572 * r - 0.385428 * g + 0.5000 * b;
    float v =  0.5000 * r - 0.454153 * g - 0.045847 * b;

    return saturate(float3(y, u + 0.5, v + 0.5));
	
	/*y = clamp(y, 0.0f, 255.0f);
	u = clamp(u, 0.0f, 255.0f);
	v = clamp(v, 0.0f, 255.0f);
	
    return float3(y,u,v) ;*/
}
#define EQN_EPS 1e-9f

static bool isZero(float x) {
	return (x > -EQN_EPS && x < EQN_EPS);
}
static int2 float2toint2(float2 tc,int w,int h)
{

	tc = clamp(tc, 0.0, 1.0); 
	int2 tcInt;

	tcInt.x = int(tc.x * w ); 
	tcInt.y = int(tc.y * h );
	tcInt.x = clamp(tcInt.x, 0, w - 1);
    tcInt.y = clamp(tcInt.y, 0, h - 1);
	return tcInt;
}


static float2 int2tofloat2(int2 tc,float w, float h)
{
	if (w == 0.0f || h == 0.0f) {
		return float2(0.0f, 0.0f);
	}

	tc.x = clamp(tc.x, 0, int(w-1));
	tc.y = clamp(tc.y, 0, int(h-1));

	float2 tcfloat2 = float2((float(tc.x) + 0.5f) / w, (float(tc.y) + 0.5f) / h);
	return tcfloat2;
}

static float minmax(int y, int min, int max)
{
	if (y > max) 
		y = max;
	else if (y < min)
		y = min;
	return float(y);
}
PS_OUTPUT PS_2D( VS_OUTPUT In)
{ 
    PS_OUTPUT Output;
    float ow = float(overlay_Width);
    float oh = float(overlay_Height);
    float bw = float(dst_Width);
    float bh = float(dst_Height);
    float2 tc = In.TextureUV;
    int w = int(tc.x * overlay_Width);
    int h = int(tc.y * overlay_Height);
    float one_pixelX = 1.0 / ow;
    float one_pixelY = 1.0 / oh;
    
    float4 InRGBAColor = overlay.Sample(TextureSampler, tc) ;
    float3 yuv = NV12ToRGB_CSC(InRGBAColor);	

    float4 InRGBAColor1 = overlay.Sample(TextureSampler, float2(tc.x + one_pixelX, tc.y));
    float3 yuv1 = NV12ToRGB_CSC(InRGBAColor1);	    
    
    float4 InRGBAColor2 = overlay.Sample(TextureSampler, float2(tc.x , tc.y + one_pixelY));
    float3 yuv2 = NV12ToRGB_CSC(InRGBAColor2);	

    float4 InRGBAColor3 = overlay.Sample(TextureSampler, float2(tc.x + one_pixelX , tc.y + one_pixelY));
    float3 yuv3 = NV12ToRGB_CSC(InRGBAColor3);	

    float3 retUV = (yuv + yuv1 + yuv2 + yuv3) / 4.0f;   
	
	Output.ColorY = retUV.x;
    
    return Output;

}
PS_OUTPUT2 PS_2D2( VS_OUTPUT In)
{ 
    PS_OUTPUT2 Output;
    float ow = float(overlay_Width);
    float oh = float(overlay_Height);
    float bw = float(dst_Width);
    float bh = float(dst_Height);
    float2 tc = In.TextureUV;
    int2  tcin2 = float2toint2(tc,dst_Width /2,dst_Height/2);
    tcin2.x = tcin2.x * 2;
    tcin2.y = tcin2.y * 2;
    float2 floattc2 = int2tofloat2(tcin2,float(overlay_Width),float(overlay_Height));
    // float one_pixelX = 1.0 / ow;
    // float one_pixelY = 1.0 / oh;
    
    float4 InRGBAColor = overlay.Sample(TextureSampler, floattc2);
    float3 yuv = NV12ToRGB_CSC(InRGBAColor) ;	

//     float4 InRGBAColor1 = overlay.Sample(TextureSampler, float2(tc.x + one_pixelX, tc.y));
//     float3 yuv1 = NV12ToRGB_CSC(InRGBAColor1);	    
    
//     float4 InRGBAColor2 = overlay.Sample(TextureSampler, float2(tc.x , tc.y + one_pixelY));
//     float3 yuv2 = NV12ToRGB_CSC(InRGBAColor2) ;	

//     float4 InRGBAColor3 = overlay.Sample(TextureSampler, float2(tc.x + one_pixelX , tc.y + one_pixelY)) ;
//     float3 yuv3 = NV12ToRGB_CSC(InRGBAColor3);	

//    float3 retUV = (yuv + yuv1 + yuv2 + yuv3) / 4.0;   
   float3 retUV = yuv ;   
	
   Output.ColorUV = float2(retUV.y,retUV.z);
    
    return Output;

}
// 
VS_OUTPUT VS_2D(VS_INPUT vin)
{
	VS_OUTPUT vOut;
	vOut.Position = vin.Position;
	vOut.TextureUV = vin.TextureUV;
	return vOut;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target using D3D11 Techniques
//--------------------------------------------------------------------------------------
technique11 ColorTech
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, VS_2D()));
		SetPixelShader(CompileShader(ps_4_0, PS_2D()));

	}
	pass P1
	{
		SetVertexShader(CompileShader(vs_4_0, VS_2D()));
		SetPixelShader(CompileShader(ps_4_0, PS_2D2()));
	}
}

