


//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
Texture2D overlay;            // Color texture for mesh
int mode;
float    g_fTime;                   // App's time in seconds
int overlay_Width;
int overlay_Height;
int back_Width;
int back_Height;


//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
SamplerState TextureSampler
{
    Filter = MIN_MAG_MIP_NEAREST;
    AddressU = Wrap;
    AddressV = Wrap;
};

struct VS_INPUT
{
    float4 Position   : POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD0;   // vertex texture coords 
};

struct VS_OUTPUT
{
    float4 Position   : SV_POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD1;   // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : SV_Target;  // Pixel color
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
//BT. 709, color Range:Limited.   (CSC) , default mode 

float4 funcNv12ToRGBABT709CSC(float3 yuv)
{
	float3 rgb;
	rgb.x = 1.1644 * (yuv.x - 16.0) + 1.7927 * (yuv.z - 128.0);
	rgb.y = 1.1644 * (yuv.x - 16.0) - 0.5329 * (yuv.z - 128.0) - 0.2132 * (yuv.y - 128.0);
	rgb.z = 1.1644 * (yuv.x - 16.0) + 2.1123 * (yuv.y - 128.0);
	return (float4)(rgb /255.0, 1.0);
}

//BT. 709, color Range: Full.  (HDTV)
float4 funcNv12ToRGBABT709HDTV(float3 yuv)
{
	float3 rgb;
	rgb.x = yuv.x + 1.5748 * (yuv.z - 128.0);
	rgb.y = yuv.x - 0.4681 * (yuv.z - 128.0) - 0.1873 * (yuv.y - 128.0);
	rgb.z = yuv.x + 1.8556 * (yuv.y - 128.0);
	return (float4)(rgb/255.0, 1.0);
}


//BT.601 PAL/ BT.601 NTSC /SMPTE 240M, color Range:Limited (CSC)
float4 funcNv12ToRGBABT601CSC(float3 yuv)
{
	float3 rgb;
	rgb.x = 1.1644 * (yuv.x - 16.0) + 1.5960 * (yuv.z - 128.0);
	rgb.y = 1.1644 * (yuv.x - 16.0) - 0.8129 * (yuv.z - 128.0)- 0.3917 * (yuv.y - 128.0);
	rgb.z = 1.1644 * (yuv.x - 16.0) + 2.0172 * (yuv.y - 128.0);
	return (float4)(rgb/255.0, 1.0);
}

//BT.601 PAL/ BT.601 NTSC /SMPTE 240M,, color Range:Full
float4 funcNv12ToRGBABT601HDTV(float3 yuv)
{
	float3 rgb;
	rgb.x = yuv.x + 1.4746 * (yuv.z - 128.0);
	rgb.y = yuv.x - 0.5713 * (yuv.z - 128.0) - 0.1645 * (yuv.y - 128.0);
	rgb.z = yuv.x + 1.8814 * (yuv.y - 128.0);
	return (float4)(rgb/255.0, 1.0);
}
float4 choosMode(float3 yuv, int _mode)
{
	yuv = yuv * 255.0;
	float4 outColor;
	switch(_mode)
	{
		case 0: //BT. 709, color Range:Limited.   (CSC) , default mode 
			outColor = funcNv12ToRGBABT709CSC(yuv);
			break;
		case 1: //BT. 709, color Range: Full. 
			outColor = funcNv12ToRGBABT709HDTV(yuv);
			break;
		case 2: //BT.601 PAL/ BT.601 NTSC /SMPTE 240M, color Range:Limited 
			outColor = funcNv12ToRGBABT601CSC(yuv);
			break;
		case 3://BT.601 PAL/ BT.601 NTSC /SMPTE 240M,, color Range:Full
			outColor = funcNv12ToRGBABT601HDTV(yuv);
			break;		
		default : 
			outColor = funcNv12ToRGBABT601CSC(yuv);
			break;
	}
	return outColor;
}
#define EQN_EPS 1e-9f

static bool isZero(float x) {
	return (x > -EQN_EPS && x < EQN_EPS);
}

PS_OUTPUT PS_2D( VS_OUTPUT In)
{ 
    PS_OUTPUT Output;
    float ow = float(overlay_Width);
    float oh = float(overlay_Height);
    float bw = float(back_Width);
    float bh = float(back_Height);
    float2 tc = In.TextureUV;
    float w = ((float)(tc.x) + 0.5) * (float)(overlay_Width) / (float)(back_Width);
	float h = ((float)(tc.y) + 0.5) * (float)(overlay_Height) / (float)(back_Height);
    int nH = (int)(overlay_Height + 1) / 2;
    int nw = (int)(w);
    int nh = (int)(h);
    int x = nw / 2 + (overlay_Width + 1) / 2 * (nh % 2);
    int ux = nw / 2 + (overlay_Width + 1) / 2 * ((nh % 4) / 2);

    float4 InYColor = overlay.Sample(TextureSampler, (float2)(x / ow, (nh / 2) / oh ));
    float4 InUVColor = overlay.Sample(TextureSampler, (float2)(ux / ow, (nh / 4 + nH) / oh));

    float4 retColor = (float4)(0.0,0.0,0.0,0.0);
    if( nw % 2 ==0)   
        retColor = choosMode((float3)(InYColor.x,InUVColor.x,InUVColor.y), mode);
    else
        retColor = choosMode((float3)(InYColor.y,InUVColor.x,InUVColor.y), mode);
    Output.RGBColor = retColor;

    return Output;

}

// 
VS_OUTPUT VS_2D(VS_INPUT vin)
{
	VS_OUTPUT vOut;
	vOut.Position = vin.Position;
	vOut.TextureUV = vin.TextureUV;
	return vOut;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target using D3D11 Techniques
//--------------------------------------------------------------------------------------
technique11 ColorTech
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, VS_2D()));
		SetPixelShader(CompileShader(ps_4_0, PS_2D()));

	}
}

